/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aAplicacionInvocante;
import com.ejie.ab18a.service.Ab18aAplicacionInvocanteService;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/aplicacion")
public class Ab18aAplicacionMtoController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aAplicacionMtoController.class);

	@Autowired
	private Ab18aAplicacionInvocanteService ab18aAplicacionInvocanteService;

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewMantenimiento() {
		logger.info("mantenimiento de Aplicaciones Invocantes");
		return "ab18aAplicacionMantenimiento";
	}

	/**
	 * Buscamos las aplicaciones invocantes correspondientes a los valores del
	 * filtro
	 **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aAplicacionInvocante> buscarAplicaciones(@ModelAttribute() Ab18aAplicacionInvocante appInvocanteFiltro,
			@ModelAttribute() JQGridRequestDto request) {

		List<Ab18aAplicacionInvocante> listaApp = new ArrayList<Ab18aAplicacionInvocante>();
		Long recordNum = Long.valueOf("12125");
		try {
			appInvocanteFiltro.setT03ModoRecepcion(null);
			listaApp = this.ab18aAplicacionInvocanteService.findAllLike(appInvocanteFiltro, request, false);
			recordNum = this.ab18aAplicacionInvocanteService.findAllLikeCount(appInvocanteFiltro, false);
		} catch (Exception e) {
			Ab18aAplicacionMtoController.logger
					.error("Ab18aAplicacionMtoController - buscarAplicaciones() - Error al obtener las aplicaciones invocantes - " + e);
		}

		JQGridResponseDto<Ab18aAplicacionInvocante> response = new JQGridResponseDto<Ab18aAplicacionInvocante>(request, recordNum, listaApp);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aAplicacionInvocante guardarMantenimiento(@RequestBody Ab18aAplicacionInvocante mantenimiento) {
		Ab18aAplicacionInvocante mantenimientoAux = null;

		if (mantenimiento.getT03IdAplicacion() != null && mantenimiento.getT03IdAplicacion() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aAplicacionInvocanteService.update(mantenimiento);
			Ab18aAplicacionMtoController.logger.info("[POST] : Ab18aTipoPeticion mantenimiento actualizado correctamente");
		} else {
			/**
			 * Si tenemos idRegistro vacío es un alta de registro
			 */
			try {
				mantenimientoAux = this.ab18aAplicacionInvocanteService.add(mantenimiento);
				Ab18aAplicacionMtoController.logger.info("[POST] : Ab18aTipoPeticion mantenimiento insertado correctamente");
			} catch (Exception e) {
				Ab18aAplicacionMtoController.logger.error("[POST] : Ab18aTipoPeticion error al añadir un registro al mantenimiento: " + e);
			}
		}

		mantenimientoAux.setT03ModoRecepcion(null);

		return mantenimientoAux;
	}
}
